package row_data_gateway;
import db_context.DbContext;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Item{
    private Integer id;
    private String name;
    private BigDecimal weight;
    private BigDecimal price;
    private Integer uninsured_ratio;
    private Integer package_id;

    public Integer getId() {
        return id;
    }
    public void setId(Integer id) {
        this.id = id;
    }

    public BigDecimal getWeight() {
        return weight;
    }
    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public BigDecimal getPrice() {
        return price;
    }
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getUninsured_ratio() {
        return uninsured_ratio;
    }
    public void setUninsured_ratio(Integer uninsured_ratio) {
        this.uninsured_ratio = uninsured_ratio;
    }

    public Integer getPackage_id() {
        return package_id;
    }
    public void setPackage_id(Integer package_id) {
        this.package_id = package_id;
        if(package_id == 0) this.package_id = null;
    }

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO items (name, weight, price, uninsured_ratio, package_id) VALUES (?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setString(1, name);
            s.setBigDecimal(2, weight);
            s.setBigDecimal(3, price);
            s.setInt(4, uninsured_ratio);
            s.setNull(5, java.sql.Types.INTEGER);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE items SET name = ?, weight = ?, price = ?, uninsured_ratio = ?, package_id = ? WHERE id = ?")) {
            s.setString(1, name);
            s.setBigDecimal(2, weight);
            s.setBigDecimal(3, price);
            s.setInt(4, uninsured_ratio);
            if(package_id == null){
                s.setNull(5, java.sql.Types.INTEGER);
            }else{
                s.setInt(5, package_id);
            }
            s.setInt(6, id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM items WHERE id = ?")) {
            s.setInt(1, id);
            s.executeUpdate();
        }
    }

    public void print(Item item) {
        if (item == null) {
            throw new NullPointerException("customer cannot be null");
        }
        System.out.print(space(fitPreSpace(item.getId().toString(),6)));
        System.out.print(item.getId());
        System.out.print(space(fitPostSpace(item.getId().toString(),6)));

        System.out.print(space(fitPreSpace(item.getName(),12)+1));
        System.out.print(item.getName());
        System.out.print(space(fitPostSpace(item.getName(),12)));

        System.out.print(space(fitPreSpace(item.getWeight().toString(),12)+1));
        System.out.print(item.getWeight() + "kg");
        System.out.print(space(fitPostSpace(item.getWeight().toString(),12)));

        System.out.print(space(fitPreSpace(item.getPrice().toString(),12)+1));
        System.out.print(item.getPrice() + "€");
        System.out.print(space(fitPostSpace(item.getPrice().toString(),12)));

        System.out.print(space(fitPreSpace(item.getUninsured_ratio().toString(),16)+1));
        System.out.print(item.getUninsured_ratio() + "%");
        System.out.print(space(fitPostSpace(item.getUninsured_ratio().toString(),16)));

        String pckg = "null";
        if(item.getPackage_id() != null)pckg = item.getPackage_id().toString();
        System.out.print(space(fitPreSpace(pckg,14)+1));
        System.out.print(pckg);
        System.out.print(space(fitPostSpace(pckg,14)));
        System.out.println();
    }

    public String space(int n){
        String vysl = "";
        for(int i = 0; i < n; i++){
            vysl += " ";
        }
        return vysl;
    }

    public int fitPreSpace(String var, int space){
        return (space - var.length())/2;
    }
    public int fitPostSpace(String var, int space){
        return (space - var.length())/2 + (space - var.length())%2;
    }
}
